// -------------------------------------------------------------------------
/**
 *  This ArrayBag collection holds items of a generic data type with no
 *  particular order. Duplicate items are allowed.
 *
 *  @author Kevin Buffardi and CMPS 1600 students
 *  @version Feb 10, 2014
 */

public class ArrayBag<T> implements Collection<T>
{
    private final static int INITIAL_CAPACITY = 10;
    private T[] contents;
    private int size;

    /**
     * Constructor initializes an empty collection w/ an initial capacity
     */
    public ArrayBag()
    {
        contents = (T[])new Object[INITIAL_CAPACITY];
        size = 0;
    }

    /**
     * add a new item into the bag (arbitrary order)
     * @param item - element to be added into the bag
     */
    public void add(T item)
    {
        if( contents.length == size )
        {
            resize();
            contents[size] = item;
            size = size+1;
        }
        else
        {
            contents[size]=item;
            size = size + 1;
        }
    }

    /**
     * helper method for expanding the capacity of the bag
     */
    private void resize()
    {
        T[] temp = (T[])new Object[size+INITIAL_CAPACITY];
        for(int i=0; i<size; i++)
        {
            temp[i]=contents[i];
        }
        contents = temp;
    }

    /**
     * removes ALL items within the bag that match
     * @param item - matching item to be removed from bag
     */
    public void remove(T item)
    {
        for(int i = 0; i<size; i++)
        {
            if( contents[i].equals(item) )
            {
                for(int j=i; j<size-1; j++)
                    contents[i]=contents[i+1];
                size=size-1;
            }
        }
    }

    /**
     * checks whether or not an item is within the bag
     * @param item - item to match within bag
     * @return true if the item exists at least once within bag
     */
    public boolean contains(T item)
    {
        for(int i = 0; i<size; i++)
        {
            if( contents[i].equals(item) )
            {
                return true;
            }
        }
        return false;
    }
}