
public class ArrayStack implements Stack {
	final private static int DEFAULT_CAPACITY = 50;
	
	private int[] S;
	private int top; //top of stack
	
	// constructor
	public ArrayStack(int capacity){
		S = new int[capacity];
		top=-1; //empty stack
	}
	
	public ArrayStack(){
		S = new int[DEFAULT_CAPACITY];
		top=-1;
	}
	
	/*
	 * Need to throw exception when stack is full.
	 */
	public void push(int x){
		S[++top]=x;
		/* Short for:
		 * top=top+1;
		 * S[top]=x;
		 */
	}
	
	
	/*
	 * Delete top element of a non-empty stack, and return it.
	 * If stack is empty, throw an exception.
	 * 
	 * Input specification: 0 <= top && top <= S.length-1
	 * Output specification: returnValue==S[top] && top_out=top-1 && -1 <= top_out && top_out <= S.length-1
	 */
	public int pop(){
		if(top>=0)
			return S[top--];
		else
			throw new RuntimeException("Stack is empty.");
		/*
		 * int returnValue = S[top];
		 * top--;
		 * return returnValue;
		 */
	}
	
	public String toString(){
		String s="Stack of capacity "+S.length+", ";
		for(int i=0; i<=top; i++){
			s+=S[i]+" ";
		}
		s+="<-top";
		return s;
	}
	

}
